# Support

> This project has a [code of conduct][coc].
> By interacting with this repository, organization, or community you agree to abide by its terms.

Hi!  👋
We’re excited that you’re using **Mautic** and we’d love to help.

To help us help you, please read through the following guidelines.

Please understand that people involved with this project often do so for fun, next to their day job; you are not entitled to free customer service.

## Contents

*   [Getting support](#getting-support)
    *   [Asking quality questions](#asking-quality-questions)
*   [Contributions](#contributions)
*   [Chatting with the community](#chatting-with-the-community)
*   [License](#license)

## Getting support

The Mautic Community provides support through our [Community Forums][forums]. We ask that you please **post any and all support questions** on the forum.  Posting them on Github will result in the issue being closed and you will be asked to post on the forums. Posting on Slack will result in you being asked to post them on the forum.  So, please post it on the forum first time and don't waste the time of our team :)

The reason we as this of you is because:

* Our forum is very well indexed by search engines, which helps others find the answers to questions and problems quickly - questions in Slack are not searchable or indexed
* You can search the forum and see if others already had - and fixed or addressed - this issue
* Our forum has an intuitive search-while-you-type system which means you will be presented with existing posts that might be related to your issue
* We need to keep Github issues decluttered, only being used for suspected or confirmed bugs with Mautic - not requests for support - so that our developers can focus on making Mautic better
* Our volunteers are able to have one place to look for and answer support questions, which helps them use their time more effectively

Read more about how we use Slack and the forums together [here][slack-forums].

If you think you've found a bug but you're not sure, please post first on the forums. Then our community can help you to debug and troubleshoot, and raise an issue on Github at a later date, if indeed it is a bug. We have Github integrated with our forums, so if you mention an issue or PR on the forums it will be linked up to the Github issue/PR by a comment in the stream.

### Asking quality questions

Help us help you!

Spending time framing a question and adding support links or resources makes it much easier for us to help.

It’s easy to fall into the trap of asking something too specific when you’re close to a problem.

Then, those trying to help you out have to spend a lot of time asking additional questions to understand what you are hoping to achieve.

Spending the extra time up front can help save everyone time in the long run.

Using the post template helps volunteers to understand the problem and jump in to help with troubleshooting. If you don't include all the details requested, you are much less likely to have people help you.

*   Try to define what you need help with:
    *   Is there something in particular you want to do?
    *   What problem are you encountering and what steps have you taken to try and fix it?
    *   Is there a concept you’re not understanding?
    *   What is your server environment setup? 
*   Learn about the [rubber duck debugging method][rubberduck] and use this to help you explain the points above!
*   Avoid falling for the [XY problem][xy]
*   Search on the [forums][forums] and GitHub to see if a similar question has been asked
*   If possible, provide sample code, a [CodeSandbox][codesandbox], or screenshots/screen capture video/s
*   The more time you put into asking your question, the better we can help you

## Chatting with the community

We have the opportunity for you to chat with the community on [Slack][chat]!

Jump in there and lurk, talk to us, and get to know the community.

## Contributions

See [`contributing.md`][contributing] on how to contribute to Mautic.

## License

This document is based on the [SUPPORT.md from RemarksJS][supportmd] [CC-BY-4.0][license] © [Titus Wormer][author]

<!-- Definitions -->

[license]: https://creativecommons.org/licenses/by/4.0/

[author]: https://wooorm.com

[coc]: https://github.com/mautic/mautic/blob/staging/code-of-conduct.md

[forums]: <https://forum.mautic.org>

[slack-forums]: <https://forum.mautic.org/t/using-the-community-forums-with-slack/12011>

[rubberduck]: https://rubberduckdebugging.com

[xy]: https://meta.stackexchange.com/questions/66377/what-is-the-xy-problem/66378#66378

[codesandbox]: https://codesandbox.io

[chat]: https://mautic.org/slack

[contributing]: contributing.md

[supportmd]: <https://github.com/remarkjs/.github/blob/main/support.md>
