<div align="center">
	
<img src=".github/readme_logo.png" alt="Mautic Open Source Marketing Automation" width="150" height="150">
	<h1 align="center"><b>Mautic</b></h1>
	<p align="center">
		Open Source Marketing Automation Software.
    <br />
    <a href="https://mautic.org"><strong>🌐 mautic.org</strong></a><br /><br />
<a href="https://digitalpublicgoods.net/r/mautic"><img src="https://img.shields.io/badge/Verified-DPG%20(Since%20%202024)-3333AB?logo=data:image/svg%2bxml;base64,PHN2ZyB3aWR0aD0iMzEiIGhlaWdodD0iMzMiIHZpZXdCb3g9IjAgMCAzMSAzMyIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTE0LjIwMDggMjEuMzY3OEwxMC4xNzM2IDE4LjAxMjRMMTEuNTIxOSAxNi40MDAzTDEzLjk5MjggMTguNDU5TDE5LjYyNjkgMTIuMjExMUwyMS4xOTA5IDEzLjYxNkwxNC4yMDA4IDIxLjM2NzhaTTI0LjYyNDEgOS4zNTEyN0wyNC44MDcxIDMuMDcyOTdMMTguODgxIDUuMTg2NjJMMTUuMzMxNCAtMi4zMzA4MmUtMDVMMTEuNzgyMSA1LjE4NjYyTDUuODU2MDEgMy4wNzI5N0w2LjAzOTA2IDkuMzUxMjdMMCAxMS4xMTc3TDMuODQ1MjEgMTYuMDg5NUwwIDIxLjA2MTJMNi4wMzkwNiAyMi44Mjc3TDUuODU2MDEgMjkuMTA2TDExLjc4MjEgMjYuOTkyM0wxNS4zMzE0IDMyLjE3OUwxOC44ODEgMjYuOTkyM0wyNC44MDcxIDI5LjEwNkwyNC42MjQxIDIyLjgyNzdMMzAuNjYzMSAyMS4wNjEyTDI2LjgxNzYgMTYuMDg5NUwzMC42NjMxIDExLjExNzdMMjQuNjI0MSA5LjM1MTI3WiIgZmlsbD0id2hpdGUiLz4KPC9zdmc+Cg==" alt="DPG Badge"></a>
    <br />
    <br />
    <a href="https://mautic.org/start-using-mautic/try-mautic/">Request a trial</a> · <a href="https://www.mautic.org/download">Self-host/download</a> · <a href="https://www.mautic.org/community">Community channels</a>
</div>

<div align="center">

[![Codecov](https://codecov.io/gh/mautic/mautic/branch/6.x/graph/badge.svg)](https://codecov.io/gh/mautic/mautic) 
[![Best Practices](https://www.bestpractices.dev/projects/9527/badge)](https://www.bestpractices.dev/projects/9527)
[![All Contributors](https://img.shields.io/github/all-contributors/mautic/mautic?color=ee8449&style=flat-square)](#contributors)

</div>


<h2 align="center">⭐ Like what we're doing? Give us a star ⬆️</h2>


## 🗒️ About Mautic

Mautic is the world’s largest open source marketing automation project. We empower businesses and organizations to deliver fully integrated marketing campaigns by providing powerful, world-class open source marketing automation software supported by a thriving, worldwide community of passionate contributors.

Our vision is to be the most privacy-focused, accessible and extendable marketing automation product on the market, giving everyone the power to understand, manage and grow their business or organization while respecting and safeguarding the privacy of their end users.

In short: Mautic is the most privacy-focused, accessible and extendable marketing automation product on the market.

### ✨ Benefits over regular marketing automation tools

- 🌐 It's open source - use it for free, no strings attached
- 🏠 Don't rely on third-party SaaS, run your own marketing automation
- 🗄️ Use your own database and own your data
- 🔓 No vendor lock-in - switch or modify at will
- 🔧 Create any integration you need
- ⚡ Build stronger campaigns, without feature limitations
- 🛠️ Both frontend and backend are 100% customizable
- 📡 Multi-channel marketing without extra costs
- 📊 Unlimited segmentation and automation

Stay up to date about initiatives, releases and strategy via our [blog][mautic-blog].

Marketing automation has historically been difficult to implement within organisations. The Mautic Community is an example of open source at its best, offering great software and a vibrant and caring community in which to learn and share knowledge.

Open source means more than open code. Open source provides equality for all and a chance for everyone to improve.

<div align="center">
	
<img src=".github/readme_image.png" alt="Mautic Open Source Marketing Automation">

</div>

## Get Involved Quickly

Calling all potential contributors to open source! Get started quickly and show us what you’re made of.

- 🐛 [Easy-to-fix bugs][t1-issues]
- 🧪 [Best pull requests for testing][best-pulls]
- 🌟[Low and no-code tasks][low-no-code]

If you have questions, [check how to contribute](#-contribution).

## Using Mautic

### ☁️ Deploy instantly with our Trials

[Request a trial][mautic-trials] filling up a form to deploy in minutes and test Mautic now.

### 🚀 Self-host completely free, forever

Please check the latest supported versions on the [Mautic Releases][mautic-releases] page.

The GitHub version is recommended for both development and testing. The production package (including all libraries) is available at [mautic.org/download][download-mautic].

Check out the [requirements for installation][requirements] and [supported versions][supported-versions].

### Installation
> [!WARNING]
> <sub>*Install from GitHub only if you are comfortable using the command line and are working locally. You'll be required to use various CLI commands to get Mautic working and keep it working. If the source/database schema gets out of sync with Mautic releases, the release updater may not work and will require manual updates. For production, we recommend installing with Composer, or using the pre-packaged Mautic which is available at [mautic.org/download][download-mautic].*
*Also note that source code outside of a [tagged release][tagged-release] should be considered ‘alpha’. It may contain bugs, cause unexpected results, data corruption or loss, and is not recommended for use in a production environment. Use at your own risk.*</sub>

### How to install Mautic
You must already have [Composer][composer] available on your computer because this is a development release and you'll need Composer to download the vendor packages.

Also note that if you have DDEV installed, you can run 'ddev start' as a DDEV project’s configuration is present in the repo. This will kick off the Mautic first-run process which will automatically install dependencies and configure Mautic for use. ✨ 🚀 Read more [here][ddev-mautic]

We recommend installing via Composer following the documentation at the [command line][install-mautic-composer].

If you must install from the zip file, it's a three-step process:

1. [Download the repository zip][download-zip] then extract the zip to your web root, or pull it in through Composer at the .
2. Run the `composer install` command to install the required packages.
3. Open your browser and complete the installation through the web installer.

You must already have [Composer][composer] available on your computer because this is a development release and you'll need Composer to download the vendor packages.

Also note that if you have DDEV installed, you can run 'ddev config' followed by 'ddev start'. This will kick off the Mautic first-run process which will automatically install dependencies and configure Mautic for use. ✨ 🚀 Read more [here][ddev-mautic]

## 🚨 Need help?

There are lots of good conversations and resources in our Forums. If you're struggling with something, chances are, someone's already solved what you're up against. :point_down:

- [GitHub Issues](https://github.com/mautic/mautic/issues)
- [Forum](https://forum.mautic.org/)
- [General troubleshooting][troubleshooting] page
- [User documentation](https://docs.mautic.org), including how to use Mautic
- [Developer documentation](https://devdocs.mautic.org), including API reference docs

## 🙋 Contribution
![Alt](https://repobeats.axiom.co/api/embed/b1bd91074fcb68f71b056079b889798446a5577e.svg "Repobeats analytics image")

Thank you for your desire to develop Mautic together!

❤️ This project and everyone involved in it is governed by the [Code of Conduct](https://github.com/mautic/mautic/blob/6.x/.github/CODE_OF_CONDUCT.md).

🧑‍💻 Check out our [contributing guide][contributing-md] and [Contributing Code][contribute-developer] to learn about asking questions, creating issues, or submitting pull requests.

🫢 For security findings, please fill [this form](https://github.com/mautic/mautic/security/advisories/new) and refer to our [security guide](https://github.com/mautic/mautic/security) for more information.

🤝 Follow us on [Github](https://github.com/mautic), [Twitter][twitter], [Facebook][facebook] and our [Slack][slack] channel.

Thanks goes to these wonderful people ([emoji key](https://allcontributors.org/docs/en/emoji-key)):

<!-- ALL-CONTRIBUTORS-LIST:START - Do not remove or modify this section -->
<!-- prettier-ignore-start -->
<!-- markdownlint-disable -->
<table>
  <tbody>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="https://twitter.com/dennisameling"><img src="https://avatars.githubusercontent.com/u/17739158?v=4?s=100" width="100px;" alt="Dennis Ameling"/><br /><sub><b>Dennis Ameling</b></sub></a><br /><a href="https://github.com/mautic/mautic/commits?author=dennisameling" title="Code">💻</a> <a href="#userTesting-dennisameling" title="User Testing">📓</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://steercampaign.com"><img src="https://avatars.githubusercontent.com/u/12627658?v=4?s=100" width="100px;" alt="Mohammad Abu Musa"/><br /><sub><b>Mohammad Abu Musa</b></sub></a><br /><a href="https://github.com/mautic/mautic/commits?author=mabumusa1" title="Code">💻</a> <a href="#userTesting-mabumusa1" title="User Testing">📓</a> <a href="https://github.com/mautic/mautic/pulls?q=is%3Apr+reviewed-by%3Amabumusa1" title="Reviewed Pull Requests">👀</a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://johnlinhart.com"><img src="https://avatars.githubusercontent.com/u/1235442?v=4?s=100" width="100px;" alt="John Linhart"/><br /><sub><b>John Linhart</b></sub></a><br /><a href="#userTesting-escopecz" title="User Testing">📓</a> <a href="https://github.com/mautic/mautic/pulls?q=is%3Apr+reviewed-by%3Aescopecz" title="Reviewed Pull Requests">👀</a> <a href="https://github.com/mautic/mautic/commits?author=escopecz" title="Code">💻</a> <a href="https://github.com/mautic/mautic/commits?author=escopecz" title="Tests">⚠️</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://www.webmecanik.com"><img src="https://avatars.githubusercontent.com/u/14075239?v=4?s=100" width="100px;" alt="Norman Pracht - Webmecanik"/><br /><sub><b>Norman Pracht - Webmecanik</b></sub></a><br /><a href="#userTesting-npracht" title="User Testing">📓</a> <a href="https://github.com/mautic/mautic/commits?author=npracht" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://webmecanik.com"><img src="https://avatars.githubusercontent.com/u/462477?v=4?s=100" width="100px;" alt="Zdeno Kuzmany"/><br /><sub><b>Zdeno Kuzmany</b></sub></a><br /><a href="#userTesting-kuzmany" title="User Testing">📓</a> <a href="https://github.com/mautic/mautic/pulls?q=is%3Apr+reviewed-by%3Akuzmany" title="Reviewed Pull Requests">👀</a> <a href="https://github.com/mautic/mautic/commits?author=kuzmany" title="Code">💻</a> <a href="https://github.com/mautic/mautic/commits?author=kuzmany" title="Tests">⚠️</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/stevedrobinson"><img src="https://avatars.githubusercontent.com/u/866855?v=4?s=100" width="100px;" alt="Steve Robinson"/><br /><sub><b>Steve Robinson</b></sub></a><br /><a href="#userTesting-stevedrobinson" title="User Testing">📓</a> <a href="https://github.com/mautic/mautic/issues?q=author%3Astevedrobinson" title="Bug reports">🐛</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/snoblucha"><img src="https://avatars.githubusercontent.com/u/265586?v=4?s=100" width="100px;" alt="Petr Šnobl"/><br /><sub><b>Petr Šnobl</b></sub></a><br /><a href="https://github.com/mautic/mautic/commits?author=snoblucha" title="Code">💻</a> <a href="https://github.com/mautic/mautic/issues?q=author%3Asnoblucha" title="Bug reports">🐛</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/luguenth"><img src="https://avatars.githubusercontent.com/u/9964009?v=4?s=100" width="100px;" alt="Lukas Günther"/><br /><sub><b>Lukas Günther</b></sub></a><br /><a href="https://github.com/mautic/mautic/commits?author=luguenth" title="Code">💻</a> <a href="https://github.com/mautic/mautic/commits?author=luguenth" title="Documentation">📖</a> <a href="#userTesting-luguenth" title="User Testing">📓</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://www.ruthcheesley.co.uk"><img src="https://avatars.githubusercontent.com/u/2930593?v=4?s=100" width="100px;" alt="Ruth Cheesley"/><br /><sub><b>Ruth Cheesley</b></sub></a><br /><a href="#userTesting-rcheesley" title="User Testing">📓</a> <a href="https://github.com/mautic/mautic/pulls?q=is%3Apr+reviewed-by%3Archeesley" title="Reviewed Pull Requests">👀</a> <a href="https://github.com/mautic/mautic/commits?author=rcheesley" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/anton-vlasenko"><img src="https://avatars.githubusercontent.com/u/43744263?v=4?s=100" width="100px;" alt="Anton Vlasenko"/><br /><sub><b>Anton Vlasenko</b></sub></a><br /><a href="https://github.com/mautic/mautic/commits?author=anton-vlasenko" title="Code">💻</a> <a href="https://github.com/mautic/mautic/commits?author=anton-vlasenko" title="Tests">⚠️</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://www.linkedin.com/in/miroslavfedeles"><img src="https://avatars.githubusercontent.com/u/6388925?v=4?s=100" width="100px;" alt="Miroslav Fedeleš"/><br /><sub><b>Miroslav Fedeleš</b></sub></a><br /><a href="https://github.com/mautic/mautic/commits?author=fedys" title="Code">💻</a> <a href="https://github.com/mautic/mautic/commits?author=fedys" title="Tests">⚠️</a> <a href="#userTesting-fedys" title="User Testing">📓</a> <a href="https://github.com/mautic/mautic/pulls?q=is%3Apr+reviewed-by%3Afedys" title="Reviewed Pull Requests">👀</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/gabepri"><img src="https://avatars.githubusercontent.com/u/73728034?v=4?s=100" width="100px;" alt="gabepri"/><br /><sub><b>gabepri</b></sub></a><br /><a href="https://github.com/mautic/mautic/issues?q=author%3Agabepri" title="Bug reports">🐛</a> <a href="https://github.com/mautic/mautic/commits?author=gabepri" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://incentfit.com"><img src="https://avatars.githubusercontent.com/u/13243272?v=4?s=100" width="100px;" alt="incentfit"/><br /><sub><b>incentfit</b></sub></a><br /><a href="#userTesting-incentfit" title="User Testing">📓</a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://drahy.net"><img src="https://avatars.githubusercontent.com/u/12815758?v=4?s=100" width="100px;" alt="Lukáš Drahý"/><br /><sub><b>Lukáš Drahý</b></sub></a><br /><a href="https://github.com/mautic/mautic/commits?author=hluchas" title="Code">💻</a> <a href="https://github.com/mautic/mautic/pulls?q=is%3Apr+reviewed-by%3Ahluchas" title="Reviewed Pull Requests">👀</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="https://about.me/alanhartless"><img src="https://avatars.githubusercontent.com/u/63312?v=4?s=100" width="100px;" alt="Alan Hartless (he/him)"/><br /><sub><b>Alan Hartless (he/him)</b></sub></a><br /><a href="https://github.com/mautic/mautic/commits?author=alanhartless" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://mohitaghera.in"><img src="https://avatars.githubusercontent.com/u/2618452?v=4?s=100" width="100px;" alt="Mohit Aghera"/><br /><sub><b>Mohit Aghera</b></sub></a><br /><a href="https://github.com/mautic/mautic/commits?author=mohit-rocks" title="Code">💻</a> <a href="#userTesting-mohit-rocks" title="User Testing">📓</a> <a href="https://github.com/mautic/mautic/pulls?q=is%3Apr+reviewed-by%3Amohit-rocks" title="Reviewed Pull Requests">👀</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/domparry"><img src="https://avatars.githubusercontent.com/u/19376765?v=4?s=100" width="100px;" alt="Dom Parry"/><br /><sub><b>Dom Parry</b></sub></a><br /><a href="#userTesting-domparry" title="User Testing">📓</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/sensalot"><img src="https://avatars.githubusercontent.com/u/6697244?v=4?s=100" width="100px;" alt="sensalot"/><br /><sub><b>sensalot</b></sub></a><br /><a href="#userTesting-sensalot" title="User Testing">📓</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/shinde-rahul"><img src="https://avatars.githubusercontent.com/u/1046788?v=4?s=100" width="100px;" alt="Rahul Shinde"/><br /><sub><b>Rahul Shinde</b></sub></a><br /><a href="https://github.com/mautic/mautic/pulls?q=is%3Apr+reviewed-by%3Ashinde-rahul" title="Reviewed Pull Requests">👀</a> <a href="#userTesting-shinde-rahul" title="User Testing">📓</a> <a href="https://github.com/mautic/mautic/commits?author=shinde-rahul" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/jos0405"><img src="https://avatars.githubusercontent.com/u/4246909?v=4?s=100" width="100px;" alt="jos0405"/><br /><sub><b>jos0405</b></sub></a><br /><a href="https://github.com/mautic/mautic/commits?author=jos0405" title="Code">💻</a> <a href="#userTesting-jos0405" title="User Testing">📓</a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://veenhof.be"><img src="https://avatars.githubusercontent.com/u/161341?v=4?s=100" width="100px;" alt="Nick Veenhof"/><br /><sub><b>Nick Veenhof</b></sub></a><br /><a href="https://github.com/mautic/mautic/pulls?q=is%3Apr+reviewed-by%3Anickveenhof" title="Reviewed Pull Requests">👀</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/patrykgruszka"><img src="https://avatars.githubusercontent.com/u/8580942?v=4?s=100" width="100px;" alt="Patryk Gruszka"/><br /><sub><b>Patryk Gruszka</b></sub></a><br /><a href="https://github.com/mautic/mautic/commits?author=patrykgruszka" title="Code">💻</a> <a href="https://github.com/mautic/mautic/commits?author=patrykgruszka" title="Documentation">📖</a> <a href="https://github.com/mautic/mautic/commits?author=patrykgruszka" title="Tests">⚠️</a> <a href="https://github.com/mautic/mautic/pulls?q=is%3Apr+reviewed-by%3Apatrykgruszka" title="Reviewed Pull Requests">👀</a> <a href="#userTesting-patrykgruszka" title="User Testing">📓</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://hartmut.io"><img src="https://avatars.githubusercontent.com/u/20030306?v=4?s=100" width="100px;" alt="Alex Hammerschmied"/><br /><sub><b>Alex Hammerschmied</b></sub></a><br /><a href="https://github.com/mautic/mautic/commits?author=alexhammerschmied" title="Code">💻</a> <a href="#userTesting-alexhammerschmied" title="User Testing">📓</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://www.twentyzen.com"><img src="https://avatars.githubusercontent.com/u/1241376?v=4?s=100" width="100px;" alt="Dirk Spannaus"/><br /><sub><b>Dirk Spannaus</b></sub></a><br /><a href="https://github.com/mautic/mautic/issues?q=author%3Adsp76" title="Bug reports">🐛</a> <a href="#userTesting-dsp76" title="User Testing">📓</a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://www.linkedin.com/in/rehannischal"><img src="https://avatars.githubusercontent.com/u/43839944?v=4?s=100" width="100px;" alt="Rehan Nischal"/><br /><sub><b>Rehan Nischal</b></sub></a><br /><a href="https://github.com/mautic/mautic/issues?q=author%3ARehanNischal" title="Bug reports">🐛</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/Christophe9880"><img src="https://avatars.githubusercontent.com/u/82932885?v=4?s=100" width="100px;" alt="Christophe9880"/><br /><sub><b>Christophe9880</b></sub></a><br /><a href="#userTesting-Christophe9880" title="User Testing">📓</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/dadarya0"><img src="https://avatars.githubusercontent.com/u/48244990?v=4?s=100" width="100px;" alt="Saurabh Gupta"/><br /><sub><b>Saurabh Gupta</b></sub></a><br /><a href="https://github.com/mautic/mautic/commits?author=dadarya0" title="Code">💻</a> <a href="https://github.com/mautic/mautic/pulls?q=is%3Apr+reviewed-by%3Adadarya0" title="Reviewed Pull Requests">👀</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/tejasync"><img src="https://avatars.githubusercontent.com/u/54406786?v=4?s=100" width="100px;" alt="Tejas Navghane"/><br /><sub><b>Tejas Navghane</b></sub></a><br /><a href="https://github.com/mautic/mautic/commits?author=tejasync" title="Tests">⚠️</a> <a href="https://github.com/mautic/mautic/commits?author=tejasync" title="Code">💻</a> <a href="#userTesting-tejasync" title="User Testing">📓</a> <a href="https://github.com/mautic/mautic/pulls?q=is%3Apr+reviewed-by%3Atejasync" title="Reviewed Pull Requests">👀</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="https://www.webmecanik.com"><img src="https://avatars.githubusercontent.com/u/49391402?v=4?s=100" width="100px;" alt="Florent Petitjean - Webmecanik"/><br /><sub><b>Florent Petitjean - Webmecanik</b></sub></a><br /><a href="#userTesting-florentpetitjean" title="User Testing">📓</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/tobsowo"><img src="https://avatars.githubusercontent.com/u/5642737?v=4?s=100" width="100px;" alt="Oluwatobi Owolabi"/><br /><sub><b>Oluwatobi Owolabi</b></sub></a><br /><a href="#eventOrganizing-tobsowo" title="Event Organizing">📋</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://www.linkedin.com/in/favour-kelvin/"><img src="https://avatars.githubusercontent.com/u/39309699?v=4?s=100" width="100px;" alt="Favour Kelvin"/><br /><sub><b>Favour Kelvin</b></sub></a><br /><a href="https://github.com/mautic/mautic/commits?author=fakela" title="Documentation">📖</a> <a href="#tutorial-fakela" title="Tutorials">✅</a> <a href="#talk-fakela" title="Talks">📢</a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://poisson.phc.dm.unipi.it/~mascellani"><img src="https://avatars.githubusercontent.com/u/101675?v=4?s=100" width="100px;" alt="Giovanni Mascellani"/><br /><sub><b>Giovanni Mascellani</b></sub></a><br /><a href="https://github.com/mautic/mautic/commits?author=giomasce" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/RaphaelWoude"><img src="https://avatars.githubusercontent.com/u/47354694?v=4?s=100" width="100px;" alt="Raphael van der Woude"/><br /><sub><b>Raphael van der Woude</b></sub></a><br /><a href="#userTesting-RaphaelWoude" title="User Testing">📓</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/mannp"><img src="https://avatars.githubusercontent.com/u/4335298?v=4?s=100" width="100px;" alt="mannp"/><br /><sub><b>mannp</b></sub></a><br /><a href="https://github.com/mautic/mautic/issues?q=author%3Amannp" title="Bug reports">🐛</a> <a href="#userTesting-mannp" title="User Testing">📓</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/MarketSmart"><img src="https://avatars.githubusercontent.com/u/85239715?v=4?s=100" width="100px;" alt="MarketSmart"/><br /><sub><b>MarketSmart</b></sub></a><br /><a href="https://github.com/mautic/mautic/commits?author=MarketSmart" title="Code">💻</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="http://www.leuchtfeuer.com"><img src="https://avatars.githubusercontent.com/u/55587275?v=4?s=100" width="100px;" alt="Leon"/><br /><sub><b>Leon</b></sub></a><br /><a href="#userTesting-oltmanns-leuchtfeuer" title="User Testing">📓</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/bryanitamazonva"><img src="https://avatars.githubusercontent.com/u/79956709?v=4?s=100" width="100px;" alt="bryanitamazonva"/><br /><sub><b>bryanitamazonva</b></sub></a><br /><a href="https://github.com/mautic/mautic/issues?q=author%3Abryanitamazonva" title="Bug reports">🐛</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/n-azimy"><img src="https://avatars.githubusercontent.com/u/86242419?v=4?s=100" width="100px;" alt="n-azimy"/><br /><sub><b>n-azimy</b></sub></a><br /><a href="https://github.com/mautic/mautic/commits?author=n-azimy" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://bandism.net/"><img src="https://avatars.githubusercontent.com/u/22633385?v=4?s=100" width="100px;" alt="Ikko Ashimine"/><br /><sub><b>Ikko Ashimine</b></sub></a><br /><a href="https://github.com/mautic/mautic/commits?author=eltociear" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/maxlawton"><img src="https://avatars.githubusercontent.com/u/1194823?v=4?s=100" width="100px;" alt="Max Lawton"/><br /><sub><b>Max Lawton</b></sub></a><br /><a href="https://github.com/mautic/mautic/commits?author=maxlawton" title="Code">💻</a> <a href="https://github.com/mautic/mautic/commits?author=maxlawton" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/rohitpavaskar"><img src="https://avatars.githubusercontent.com/u/15215575?v=4?s=100" width="100px;" alt="Rohit Pavaskar"/><br /><sub><b>Rohit Pavaskar</b></sub></a><br /><a href="https://github.com/mautic/mautic/commits?author=rohitpavaskar" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://www.udemy.com/certificate/UC-5CZA2NJ8/"><img src="https://avatars.githubusercontent.com/u/22201881?v=4?s=100" width="100px;" alt="Disha P"/><br /><sub><b>Disha P</b></sub></a><br /><a href="https://github.com/mautic/mautic/commits?author=disha-pishavadia24" title="Code">💻</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="http://www.idea2.ch"><img src="https://avatars.githubusercontent.com/u/13075514?v=4?s=100" width="100px;" alt="Adrian"/><br /><sub><b>Adrian</b></sub></a><br /><a href="https://github.com/mautic/mautic/pulls?q=is%3Apr+reviewed-by%3Aadiux" title="Reviewed Pull Requests">👀</a> <a href="#userTesting-adiux" title="User Testing">📓</a> <a href="https://github.com/mautic/mautic/commits?author=adiux" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/vijayhrdm"><img src="https://avatars.githubusercontent.com/u/9714242?v=4?s=100" width="100px;" alt="vijayhrdm"/><br /><sub><b>vijayhrdm</b></sub></a><br /><a href="https://github.com/mautic/mautic/issues?q=author%3Avijayhrdm" title="Bug reports">🐛</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/julienWebmecanik"><img src="https://avatars.githubusercontent.com/u/79137416?v=4?s=100" width="100px;" alt="julienWebmecanik"/><br /><sub><b>julienWebmecanik</b></sub></a><br /><a href="https://github.com/mautic/mautic/commits?author=julienWebmecanik" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/johbuch"><img src="https://avatars.githubusercontent.com/u/31535432?v=4?s=100" width="100px;" alt="Johan Buchert"/><br /><sub><b>Johan Buchert</b></sub></a><br /><a href="#userTesting-johbuch" title="User Testing">📓</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/TS16V"><img src="https://avatars.githubusercontent.com/u/38064792?v=4?s=100" width="100px;" alt="TS16V"/><br /><sub><b>TS16V</b></sub></a><br /><a href="https://github.com/mautic/mautic/issues?q=author%3ATS16V" title="Bug reports">🐛</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/rafalsk"><img src="https://avatars.githubusercontent.com/u/9338163?v=4?s=100" width="100px;" alt="rafalsk"/><br /><sub><b>rafalsk</b></sub></a><br /><a href="https://github.com/mautic/mautic/issues?q=author%3Arafalsk" title="Bug reports">🐛</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://jonathanphoto.fr"><img src="https://avatars.githubusercontent.com/u/55917666?v=4?s=100" width="100px;" alt="Jonathan Dahan"/><br /><sub><b>Jonathan Dahan</b></sub></a><br /><a href="https://github.com/mautic/mautic/issues?q=author%3Ajonathandhn" title="Bug reports">🐛</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="http://twitter.com/j26w"><img src="https://avatars.githubusercontent.com/u/1260184?v=4?s=100" width="100px;" alt="j26w"/><br /><sub><b>j26w</b></sub></a><br /><a href="#userTesting-j26w" title="User Testing">📓</a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://theodorosploumis.com/en"><img src="https://avatars.githubusercontent.com/u/1315321?v=4?s=100" width="100px;" alt="Theodoros Ploumis"/><br /><sub><b>Theodoros Ploumis</b></sub></a><br /><a href="https://github.com/mautic/mautic/commits?author=theodorosploumis" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/sreenia806"><img src="https://avatars.githubusercontent.com/u/2764179?v=4?s=100" width="100px;" alt="Sreenivasulu Avula"/><br /><sub><b>Sreenivasulu Avula</b></sub></a><br /><a href="#userTesting-sreenia806" title="User Testing">📓</a> <a href="https://github.com/mautic/mautic/pulls?q=is%3Apr+reviewed-by%3Asreenia806" title="Reviewed Pull Requests">👀</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://www.linkedin.com/in/mohammadlahlouh/"><img src="https://avatars.githubusercontent.com/u/7312050?v=4?s=100" width="100px;" alt="Mohammad Lahlouh"/><br /><sub><b>Mohammad Lahlouh</b></sub></a><br /><a href="#userTesting-mlahlouh" title="User Testing">📓</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/ArnaudSau"><img src="https://avatars.githubusercontent.com/u/50580844?v=4?s=100" width="100px;" alt="ArnaudSau"/><br /><sub><b>ArnaudSau</b></sub></a><br /><a href="https://github.com/mautic/mautic/commits?author=ArnaudSau" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/bell87"><img src="https://avatars.githubusercontent.com/u/5338785?v=4?s=100" width="100px;" alt="Andrew Bell"/><br /><sub><b>Andrew Bell</b></sub></a><br /><a href="#userTesting-bell87" title="User Testing">📓</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/alfredoct96"><img src="https://avatars.githubusercontent.com/u/50916237?v=4?s=100" width="100px;" alt="Alfredo Arena"/><br /><sub><b>Alfredo Arena</b></sub></a><br /><a href="https://github.com/mautic/mautic/commits?author=alfredoct96" title="Code">💻</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/mollux"><img src="https://avatars.githubusercontent.com/u/3983285?v=4?s=100" width="100px;" alt="mollux"/><br /><sub><b>mollux</b></sub></a><br /><a href="https://github.com/mautic/mautic/commits?author=mollux" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://Leuchtfeuer.com"><img src="https://avatars.githubusercontent.com/u/43146234?v=4?s=100" width="100px;" alt="ekkeguembel"/><br /><sub><b>ekkeguembel</b></sub></a><br /><a href="#userTesting-ekkeguembel" title="User Testing">📓</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/MadlenF"><img src="https://avatars.githubusercontent.com/u/87804194?v=4?s=100" width="100px;" alt="Madlen"/><br /><sub><b>Madlen</b></sub></a><br /><a href="#userTesting-MadlenF" title="User Testing">📓</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://friendly.ch/kathrin"><img src="https://avatars.githubusercontent.com/u/96054002?v=4?s=100" width="100px;" alt="Kathrin Schmid"/><br /><sub><b>Kathrin Schmid</b></sub></a><br /><a href="#translation-kathrin-schmid" title="Translation">🌍</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/rahuld-dev"><img src="https://avatars.githubusercontent.com/u/68939488?v=4?s=100" width="100px;" alt="Rahul Dhande"/><br /><sub><b>Rahul Dhande</b></sub></a><br /><a href="https://github.com/mautic/mautic/commits?author=rahuld-dev" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/biozshock"><img src="https://avatars.githubusercontent.com/u/169384?v=4?s=100" width="100px;" alt="Artem Lopata"/><br /><sub><b>Artem Lopata</b></sub></a><br /><a href="#userTesting-biozshock" title="User Testing">📓</a> <a href="https://github.com/mautic/mautic/pulls?q=is%3Apr+reviewed-by%3Abiozshock" title="Reviewed Pull Requests">👀</a> <a href="https://github.com/mautic/mautic/commits?author=biozshock" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/abailey-dev"><img src="https://avatars.githubusercontent.com/u/65302481?v=4?s=100" width="100px;" alt="Anthony Bailey"/><br /><sub><b>Anthony Bailey</b></sub></a><br /><a href="https://github.com/mautic/mautic/commits?author=abailey-dev" title="Code">💻</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="http://twitter.com/eloimarques"><img src="https://avatars.githubusercontent.com/u/11034410?v=4?s=100" width="100px;" alt="Eloi Marques da Silva"/><br /><sub><b>Eloi Marques da Silva</b></sub></a><br /><a href="https://github.com/mautic/mautic/commits?author=eloimarquessilva" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://adevo.pl"><img src="https://avatars.githubusercontent.com/u/39382654?v=4?s=100" width="100px;" alt="Tomasz Kowalczyk"/><br /><sub><b>Tomasz Kowalczyk</b></sub></a><br /><a href="https://github.com/mautic/mautic/commits?author=tomekkowalczyk" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/jensolsson"><img src="https://avatars.githubusercontent.com/u/1985582?v=4?s=100" width="100px;" alt="jensolsson"/><br /><sub><b>jensolsson</b></sub></a><br /><a href="#userTesting-jensolsson" title="User Testing">📓</a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://tonybogdanov.com"><img src="https://avatars.githubusercontent.com/u/3586948?v=4?s=100" width="100px;" alt="Tony Bogdanov"/><br /><sub><b>Tony Bogdanov</b></sub></a><br /><a href="https://github.com/mautic/mautic/commits?author=TonyBogdanov" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/bradycargle"><img src="https://avatars.githubusercontent.com/u/79949869?v=4?s=100" width="100px;" alt="Brady Cargle"/><br /><sub><b>Brady Cargle</b></sub></a><br /><a href="#userTesting-bradycargle" title="User Testing">📓</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/mmarton"><img src="https://avatars.githubusercontent.com/u/1424582?v=4?s=100" width="100px;" alt="mmarton"/><br /><sub><b>mmarton</b></sub></a><br /><a href="#userTesting-mmarton" title="User Testing">📓</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/bodrak"><img src="https://avatars.githubusercontent.com/u/3704648?v=4?s=100" width="100px;" alt="bodrak"/><br /><sub><b>bodrak</b></sub></a><br /><a href="https://github.com/mautic/mautic/commits?author=bodrak" title="Code">💻</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/nick-vanpraet"><img src="https://avatars.githubusercontent.com/u/7923739?v=4?s=100" width="100px;" alt="nick-vanpraet"/><br /><sub><b>nick-vanpraet</b></sub></a><br /><a href="https://github.com/mautic/mautic/commits?author=nick-vanpraet" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/volha-pivavarchyk"><img src="https://avatars.githubusercontent.com/u/96085911?v=4?s=100" width="100px;" alt="Volha Pivavarchyk"/><br /><sub><b>Volha Pivavarchyk</b></sub></a><br /><a href="#userTesting-volha-pivavarchyk" title="User Testing">📓</a> <a href="https://github.com/mautic/mautic/commits?author=volha-pivavarchyk" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/J-Light"><img src="https://avatars.githubusercontent.com/u/2544660?v=4?s=100" width="100px;" alt="Nish Joseph"/><br /><sub><b>Nish Joseph</b></sub></a><br /><a href="https://github.com/mautic/mautic/commits?author=J-Light" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/Damzoneuh"><img src="https://avatars.githubusercontent.com/u/44919863?v=4?s=100" width="100px;" alt="Damzoneuh"/><br /><sub><b>Damzoneuh</b></sub></a><br /><a href="https://github.com/mautic/mautic/commits?author=Damzoneuh" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/alinmbb"><img src="https://avatars.githubusercontent.com/u/86683952?v=4?s=100" width="100px;" alt="alinmbb"/><br /><sub><b>alinmbb</b></sub></a><br /><a href="https://github.com/mautic/mautic/commits?author=alinmbb" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/deborahsalves"><img src="https://avatars.githubusercontent.com/u/79517214?v=4?s=100" width="100px;" alt="Déborah Salves"/><br /><sub><b>Déborah Salves</b></sub></a><br /><a href="#userTesting-deborahsalves" title="User Testing">📓</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/automatyzuj"><img src="https://avatars.githubusercontent.com/u/104569506?v=4?s=100" width="100px;" alt="automatyzuj"/><br /><sub><b>automatyzuj</b></sub></a><br /><a href="#userTesting-automatyzuj" title="User Testing">📓</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="https://www.oldschoolhack.me"><img src="https://avatars.githubusercontent.com/u/1666336?v=4?s=100" width="100px;" alt="KN4CK3R"/><br /><sub><b>KN4CK3R</b></sub></a><br /><a href="https://github.com/mautic/mautic/commits?author=KN4CK3R" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://benjamin.leveque.me"><img src="https://avatars.githubusercontent.com/u/166890?v=4?s=100" width="100px;" alt="Benjamin Lévêque"/><br /><sub><b>Benjamin Lévêque</b></sub></a><br /><a href="https://github.com/mautic/mautic/commits?author=benji07" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://buzelac.com"><img src="https://avatars.githubusercontent.com/u/430255?v=4?s=100" width="100px;" alt="Benjamin"/><br /><sub><b>Benjamin</b></sub></a><br /><a href="https://github.com/mautic/mautic/commits?author=uzegonemad" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/IrisAmrein"><img src="https://avatars.githubusercontent.com/u/70972871?v=4?s=100" width="100px;" alt="Iris Amrein"/><br /><sub><b>Iris Amrein</b></sub></a><br /><a href="#userTesting-IrisAmrein" title="User Testing">📓</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/pety-dc"><img src="https://avatars.githubusercontent.com/u/25766885?v=4?s=100" width="100px;" alt="peter.osvath"/><br /><sub><b>peter.osvath</b></sub></a><br /><a href="https://github.com/mautic/mautic/commits?author=pety-dc" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/poweriguana"><img src="https://avatars.githubusercontent.com/u/86078621?v=4?s=100" width="100px;" alt="poweriguana"/><br /><sub><b>poweriguana</b></sub></a><br /><a href="#userTesting-poweriguana" title="User Testing">📓</a> <a href="#projectManagement-poweriguana" title="Project Management">📆</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/OnyXxL"><img src="https://avatars.githubusercontent.com/u/19322954?v=4?s=100" width="100px;" alt="OnyXxL"/><br /><sub><b>OnyXxL</b></sub></a><br /><a href="#userTesting-OnyXxL" title="User Testing">📓</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/dlackovic2"><img src="https://avatars.githubusercontent.com/u/68977388?v=4?s=100" width="100px;" alt="Dominik Lacković"/><br /><sub><b>Dominik Lacković</b></sub></a><br /><a href="#userTesting-dlackovic2" title="User Testing">📓</a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://www.omertoledano.com"><img src="https://avatars.githubusercontent.com/u/33084245?v=4?s=100" width="100px;" alt="Omer Toledano"/><br /><sub><b>Omer Toledano</b></sub></a><br /><a href="#userTesting-omert37" title="User Testing">📓</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/ZebruhDivs"><img src="https://avatars.githubusercontent.com/u/110403172?v=4?s=100" width="100px;" alt="ZebruhDivs"/><br /><sub><b>ZebruhDivs</b></sub></a><br /><a href="#userTesting-ZebruhDivs" title="User Testing">📓</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/AlanWierzchonCA"><img src="https://avatars.githubusercontent.com/u/100592709?v=4?s=100" width="100px;" alt="Alan Wierzchoń"/><br /><sub><b>Alan Wierzchoń</b></sub></a><br /><a href="https://github.com/mautic/mautic/commits?author=AlanWierzchonCA" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/T0mTom"><img src="https://avatars.githubusercontent.com/u/9713824?v=4?s=100" width="100px;" alt="Tomazz Jurich"/><br /><sub><b>Tomazz Jurich</b></sub></a><br /><a href="#userTesting-T0mTom" title="User Testing">📓</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/putzwasser"><img src="https://avatars.githubusercontent.com/u/26040044?v=4?s=100" width="100px;" alt="putzwasser"/><br /><sub><b>putzwasser</b></sub></a><br /><a href="https://github.com/mautic/mautic/issues?q=author%3Aputzwasser" title="Bug reports">🐛</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/beetofly"><img src="https://avatars.githubusercontent.com/u/105105707?v=4?s=100" width="100px;" alt="erk"/><br /><sub><b>erk</b></sub></a><br /><a href="#userTesting-beetofly" title="User Testing">📓</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/doppelD-LF"><img src="https://avatars.githubusercontent.com/u/77049101?v=4?s=100" width="100px;" alt="Daniel"/><br /><sub><b>Daniel</b></sub></a><br /><a href="#userTesting-doppelD-LF" title="User Testing">📓</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/agencia904"><img src="https://avatars.githubusercontent.com/u/90470877?v=4?s=100" width="100px;" alt="agencia904"/><br /><sub><b>agencia904</b></sub></a><br /><a href="#userTesting-agencia904" title="User Testing">📓</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://marceloflorentino.000webhostapp.com"><img src="https://avatars.githubusercontent.com/u/45359558?v=4?s=100" width="100px;" alt="mbfds"/><br /><sub><b>mbfds</b></sub></a><br /><a href="#userTesting-mbfds" title="User Testing">📓</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/lucaslazarinii"><img src="https://avatars.githubusercontent.com/u/106190294?v=4?s=100" width="100px;" alt="Lucas Lazarini"/><br /><sub><b>Lucas Lazarini</b></sub></a><br /><a href="#userTesting-lucaslazarinii" title="User Testing">📓</a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://zoogon.net"><img src="https://avatars.githubusercontent.com/u/57393?v=4?s=100" width="100px;" alt="Gonzalo Cao Cabeza de Vaca"/><br /><sub><b>Gonzalo Cao Cabeza de Vaca</b></sub></a><br /><a href="#userTesting-gonzalo" title="User Testing">📓</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/Robmobius"><img src="https://avatars.githubusercontent.com/u/16938630?v=4?s=100" width="100px;" alt="Robmobius"/><br /><sub><b>Robmobius</b></sub></a><br /><a href="#userTesting-Robmobius" title="User Testing">📓</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://podtrics.com"><img src="https://avatars.githubusercontent.com/u/50760632?v=4?s=100" width="100px;" alt="Marc Beinder"/><br /><sub><b>Marc Beinder</b></sub></a><br /><a href="https://github.com/mautic/mautic/commits?author=onairmarc" title="Code">💻</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/bergwerkweb"><img src="https://avatars.githubusercontent.com/u/29873275?v=4?s=100" width="100px;" alt="bergwerkweb"/><br /><sub><b>bergwerkweb</b></sub></a><br /><a href="https://github.com/mautic/mautic/commits?author=bergwerkweb" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://rembo.me"><img src="https://avatars.githubusercontent.com/u/758957?v=4?s=100" width="100px;" alt="Rembrand"/><br /><sub><b>Rembrand</b></sub></a><br /><a href="#userTesting-LordRembo" title="User Testing">📓</a> <a href="https://github.com/mautic/mautic/commits?author=LordRembo" title="Code">💻</a> <a href="https://github.com/mautic/mautic/pulls?q=is%3Apr+reviewed-by%3ALordRembo" title="Reviewed Pull Requests">👀</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/TechBill"><img src="https://avatars.githubusercontent.com/u/945103?v=4?s=100" width="100px;" alt="TechBill"/><br /><sub><b>TechBill</b></sub></a><br /><a href="#userTesting-TechBill" title="User Testing">📓</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://stackoverflow.com/users/902161/irfan"><img src="https://avatars.githubusercontent.com/u/4272642?v=4?s=100" width="100px;" alt="Irfan Hanfi"/><br /><sub><b>Irfan Hanfi</b></sub></a><br /><a href="https://github.com/mautic/mautic/commits?author=irfanhanfi" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/annamunk"><img src="https://avatars.githubusercontent.com/u/102536220?v=4?s=100" width="100px;" alt="Anna Munk"/><br /><sub><b>Anna Munk</b></sub></a><br /><a href="https://github.com/mautic/mautic/commits?author=annamunk" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://www.schriftrolle.de/?utm_source=github&utm_medium=profilLink"><img src="https://avatars.githubusercontent.com/u/765204?v=4?s=100" width="100px;" alt="Sven Döring"/><br /><sub><b>Sven Döring</b></sub></a><br /><a href="#userTesting-sdoering" title="User Testing">📓</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://www.linkedin.com/in/pedro-de-jesus-a60527167"><img src="https://avatars.githubusercontent.com/u/42081152?v=4?s=100" width="100px;" alt="Pedro de Jesus"/><br /><sub><b>Pedro de Jesus</b></sub></a><br /><a href="https://github.com/mautic/mautic/commits?author=pedrodejesus" title="Code">💻</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/JeanMarcAivie"><img src="https://avatars.githubusercontent.com/u/127292186?v=4?s=100" width="100px;" alt="Jean-Marc "/><br /><sub><b>Jean-Marc </b></sub></a><br /><a href="#userTesting-JeanMarcAivie" title="User Testing">📓</a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://paulsanduleac.com"><img src="https://avatars.githubusercontent.com/u/67867?v=4?s=100" width="100px;" alt="Paul Sanduleac"/><br /><sub><b>Paul Sanduleac</b></sub></a><br /><a href="https://github.com/mautic/mautic/commits?author=paulsanduleac" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://lenonleite.com.br"><img src="https://avatars.githubusercontent.com/u/218436?v=4?s=100" width="100px;" alt="Lenon Leite"/><br /><sub><b>Lenon Leite</b></sub></a><br /><a href="https://github.com/mautic/mautic/commits?author=lenonleite" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/Syrgak-Alan"><img src="https://avatars.githubusercontent.com/u/96595532?v=4?s=100" width="100px;" alt="Alan Syrgak"/><br /><sub><b>Alan Syrgak</b></sub></a><br /><a href="#userTesting-Syrgak-Alan" title="User Testing">📓</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/MohHeader"><img src="https://avatars.githubusercontent.com/u/3213925?v=4?s=100" width="100px;" alt="Mohammed Header"/><br /><sub><b>Mohammed Header</b></sub></a><br /><a href="https://github.com/mautic/mautic/commits?author=MohHeader" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/danadelion"><img src="https://avatars.githubusercontent.com/u/78448517?v=4?s=100" width="100px;" alt="Dana Linhartová"/><br /><sub><b>Dana Linhartová</b></sub></a><br /><a href="https://github.com/mautic/mautic/commits?author=danadelion" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/thanks"><img src="https://avatars.githubusercontent.com/u/1121545?v=4?s=100" width="100px;" alt="Thanks"/><br /><sub><b>Thanks</b></sub></a><br /><a href="https://github.com/mautic/mautic/commits?author=Thanks" title="Tests">⚠️</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/PatrickJenkner"><img src="https://avatars.githubusercontent.com/u/139468697?v=4?s=100" width="100px;" alt="Patrick"/><br /><sub><b>Patrick</b></sub></a><br /><a href="#userTesting-PatrickJenkner" title="User Testing">📓</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://tomasvotruba.com"><img src="https://avatars.githubusercontent.com/u/924196?v=4?s=100" width="100px;" alt="Tomas Votruba"/><br /><sub><b>Tomas Votruba</b></sub></a><br /><a href="https://github.com/mautic/mautic/commits?author=TomasVotruba" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/tirtharajghosh"><img src="https://avatars.githubusercontent.com/u/58604532?v=4?s=100" width="100px;" alt="Tirtharaj Ghosh"/><br /><sub><b>Tirtharaj Ghosh</b></sub></a><br /><a href="https://github.com/mautic/mautic/commits?author=tirtharajghosh" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://www.rubnogueira.com"><img src="https://avatars.githubusercontent.com/u/40404708?v=4?s=100" width="100px;" alt="Ruben Nogueira"/><br /><sub><b>Ruben Nogueira</b></sub></a><br /><a href="https://github.com/mautic/mautic/commits?author=rubnogueira" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://exsesx.dev/"><img src="https://avatars.githubusercontent.com/u/20399517?v=4?s=100" width="100px;" alt="Oleh Vanin"/><br /><sub><b>Oleh Vanin</b></sub></a><br /><a href="https://github.com/mautic/mautic/pulls?q=is%3Apr+reviewed-by%3Aexsesx" title="Reviewed Pull Requests">👀</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/mallezie"><img src="https://avatars.githubusercontent.com/u/1926222?v=4?s=100" width="100px;" alt="Tim Mallezie"/><br /><sub><b>Tim Mallezie</b></sub></a><br /><a href="https://github.com/mautic/mautic/commits?author=mallezie" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://staabm.github.io/"><img src="https://avatars.githubusercontent.com/u/120441?v=4?s=100" width="100px;" alt="Markus Staab"/><br /><sub><b>Markus Staab</b></sub></a><br /><a href="https://github.com/mautic/mautic/commits?author=staabm" title="Code">💻</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/code5rick"><img src="https://avatars.githubusercontent.com/u/131262825?v=4?s=100" width="100px;" alt="code5rick"/><br /><sub><b>code5rick</b></sub></a><br /><a href="https://github.com/mautic/mautic/issues?q=author%3Acode5rick" title="Bug reports">🐛</a> <a href="https://github.com/mautic/mautic/commits?author=code5rick" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/jcrandell7"><img src="https://avatars.githubusercontent.com/u/59890399?v=4?s=100" width="100px;" alt="jcrandell7"/><br /><sub><b>jcrandell7</b></sub></a><br /><a href="#userTesting-jcrandell7" title="User Testing">📓</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/driskell"><img src="https://avatars.githubusercontent.com/u/939815?v=4?s=100" width="100px;" alt="Jason Woods"/><br /><sub><b>Jason Woods</b></sub></a><br /><a href="https://github.com/mautic/mautic/commits?author=driskell" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://enkhjargal.me"><img src="https://avatars.githubusercontent.com/u/2686495?v=4?s=100" width="100px;" alt="Enkhjargal Lkhagvaa"/><br /><sub><b>Enkhjargal Lkhagvaa</b></sub></a><br /><a href="https://github.com/mautic/mautic/pulls?q=is%3Apr+reviewed-by%3Aenkhjargal" title="Reviewed Pull Requests">👀</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/alexbusu-motork"><img src="https://avatars.githubusercontent.com/u/149699605?v=4?s=100" width="100px;" alt="alexbusu-motork"/><br /><sub><b>alexbusu-motork</b></sub></a><br /><a href="https://github.com/mautic/mautic/pulls?q=is%3Apr+reviewed-by%3Aalexbusu-motork" title="Reviewed Pull Requests">👀</a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://www.davidgorges.de"><img src="https://avatars.githubusercontent.com/u/3885619?v=4?s=100" width="100px;" alt="David Gorges"/><br /><sub><b>David Gorges</b></sub></a><br /><a href="https://github.com/mautic/mautic/issues?q=author%3Adavidgorges" title="Bug reports">🐛</a> <a href="https://github.com/mautic/mautic/commits?author=davidgorges" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/notz"><img src="https://avatars.githubusercontent.com/u/697251?v=4?s=100" width="100px;" alt="Gernot Pansy"/><br /><sub><b>Gernot Pansy</b></sub></a><br /><a href="https://github.com/mautic/mautic/issues?q=author%3Anotz" title="Bug reports">🐛</a> <a href="https://github.com/mautic/mautic/commits?author=notz" title="Code">💻</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/andersonjeccel"><img src="https://avatars.githubusercontent.com/u/116097999?v=4?s=100" width="100px;" alt="andersonjeccel"/><br /><sub><b>andersonjeccel</b></sub></a><br /><a href="https://github.com/mautic/mautic/commits?author=andersonjeccel" title="Code">💻</a> <a href="#a11y-andersonjeccel" title="Accessibility">️️️️♿️</a> <a href="https://github.com/mautic/mautic/commits?author=andersonjeccel" title="Documentation">📖</a> <a href="https://github.com/mautic/mautic/issues?q=author%3Aandersonjeccel" title="Bug reports">🐛</a> <a href="https://github.com/mautic/mautic/pulls?q=is%3Apr+reviewed-by%3Aandersonjeccel" title="Reviewed Pull Requests">👀</a> <a href="#userTesting-andersonjeccel" title="User Testing">📓</a> <a href="#design-andersonjeccel" title="Design">🎨</a> <a href="#projectManagement-andersonjeccel" title="Project Management">📆</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/pasxel"><img src="https://avatars.githubusercontent.com/u/1814849?v=4?s=100" width="100px;" alt="Alexei Pl"/><br /><sub><b>Alexei Pl</b></sub></a><br /><a href="https://github.com/mautic/mautic/issues?q=author%3Apasxel" title="Bug reports">🐛</a> <a href="https://github.com/mautic/mautic/commits?author=pasxel" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/alvaroenoht"><img src="https://avatars.githubusercontent.com/u/7890431?v=4?s=100" width="100px;" alt="Alvaro"/><br /><sub><b>Alvaro</b></sub></a><br /><a href="https://github.com/mautic/mautic/issues?q=author%3Aalvaroenoht" title="Bug reports">🐛</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/ajitdev"><img src="https://avatars.githubusercontent.com/u/3738249?v=4?s=100" width="100px;" alt="Ajit"/><br /><sub><b>Ajit</b></sub></a><br /><a href="https://github.com/mautic/mautic/commits?author=ajitdev" title="Code">💻</a> <a href="https://github.com/mautic/mautic/issues?q=author%3Aajitdev" title="Bug reports">🐛</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/Esthertests"><img src="https://avatars.githubusercontent.com/u/156212312?v=4?s=100" width="100px;" alt="Esthertests"/><br /><sub><b>Esthertests</b></sub></a><br /><a href="https://github.com/mautic/mautic/pulls?q=is%3Apr+reviewed-by%3AEsthertests" title="Reviewed Pull Requests">👀</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/magdalenaleonow"><img src="https://avatars.githubusercontent.com/u/130159751?v=4?s=100" width="100px;" alt="magdalenaleonow"/><br /><sub><b>magdalenaleonow</b></sub></a><br /><a href="https://github.com/mautic/mautic/issues?q=author%3Amagdalenaleonow" title="Bug reports">🐛</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/nox1134"><img src="https://avatars.githubusercontent.com/u/95358802?v=4?s=100" width="100px;" alt="Priyanshi Gaur"/><br /><sub><b>Priyanshi Gaur</b></sub></a><br /><a href="https://github.com/mautic/mautic/commits?author=nox1134" title="Code">💻</a> <a href="https://github.com/mautic/mautic/commits?author=nox1134" title="Tests">⚠️</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/magician7"><img src="https://avatars.githubusercontent.com/u/2359284?v=4?s=100" width="100px;" alt="Damian"/><br /><sub><b>Damian</b></sub></a><br /><a href="https://github.com/mautic/mautic/pulls?q=is%3Apr+reviewed-by%3Amagician7" title="Reviewed Pull Requests">👀</a> <a href="https://github.com/mautic/mautic/issues?q=author%3Amagician7" title="Bug reports">🐛</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/markusVJH"><img src="https://avatars.githubusercontent.com/u/121946942?v=4?s=100" width="100px;" alt="Markus Heinilä"/><br /><sub><b>Markus Heinilä</b></sub></a><br /><a href="https://github.com/mautic/mautic/pulls?q=is%3Apr+reviewed-by%3AmarkusVJH" title="Reviewed Pull Requests">👀</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://www.linkedin.com/in/juangadiel"><img src="https://avatars.githubusercontent.com/u/706997?v=4?s=100" width="100px;" alt="Juan Gadiel Rosado Colon"/><br /><sub><b>Juan Gadiel Rosado Colon</b></sub></a><br /><a href="https://github.com/mautic/mautic/issues?q=author%3Ajuangadiel" title="Bug reports">🐛</a> <a href="#userTesting-juangadiel" title="User Testing">📓</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://abhisek.xyz/"><img src="https://avatars.githubusercontent.com/u/12195330?v=4?s=100" width="100px;" alt="Abhisek Mazumdar"/><br /><sub><b>Abhisek Mazumdar</b></sub></a><br /><a href="https://github.com/mautic/mautic/commits?author=abhisekmazumdar" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/luk4s"><img src="https://avatars.githubusercontent.com/u/635997?v=4?s=100" width="100px;" alt="Lukas Pokorny"/><br /><sub><b>Lukas Pokorny</b></sub></a><br /><a href="https://github.com/mautic/mautic/commits?author=luk4s" title="Documentation">📖</a> <a href="https://github.com/mautic/mautic/commits?author=luk4s" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/Oluwatos94"><img src="https://avatars.githubusercontent.com/u/111003311?v=4?s=100" width="100px;" alt="Tosin Akinbowa"/><br /><sub><b>Tosin Akinbowa</b></sub></a><br /><a href="https://github.com/mautic/mautic/commits?author=Oluwatos94" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/nishant-s7"><img src="https://avatars.githubusercontent.com/u/97207366?v=4?s=100" width="100px;" alt="nishant-s7"/><br /><sub><b>nishant-s7</b></sub></a><br /><a href="https://github.com/mautic/mautic/commits?author=nishant-s7" title="Code">💻</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="https://matbcvo.github.io"><img src="https://avatars.githubusercontent.com/u/1006437?v=4?s=100" width="100px;" alt="Martin Vooremäe"/><br /><sub><b>Martin Vooremäe</b></sub></a><br /><a href="https://github.com/mautic/mautic/pulls?q=is%3Apr+reviewed-by%3Amatbcvo" title="Reviewed Pull Requests">👀</a> <a href="#userTesting-matbcvo" title="User Testing">📓</a> <a href="https://github.com/mautic/mautic/commits?author=matbcvo" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/vinzent"><img src="https://avatars.githubusercontent.com/u/296297?v=4?s=100" width="100px;" alt="Thomas Mueller"/><br /><sub><b>Thomas Mueller</b></sub></a><br /><a href="https://github.com/mautic/mautic/commits?author=vinzent" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/Bastian2718"><img src="https://avatars.githubusercontent.com/u/177823038?v=4?s=100" width="100px;" alt="Bastian2718"/><br /><sub><b>Bastian2718</b></sub></a><br /><a href="#userTesting-Bastian2718" title="User Testing">📓</a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://javad.sh"><img src="https://avatars.githubusercontent.com/u/22474016?v=4?s=100" width="100px;" alt="Javad Shafique"/><br /><sub><b>Javad Shafique</b></sub></a><br /><a href="https://github.com/mautic/mautic/commits?author=cjavad" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/Aleks0129"><img src="https://avatars.githubusercontent.com/u/182695073?v=4?s=100" width="100px;" alt="Aleks0129"/><br /><sub><b>Aleks0129</b></sub></a><br /><a href="#userTesting-Aleks0129" title="User Testing">📓</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://academy.leewayweb.com"><img src="https://avatars.githubusercontent.com/u/1532615?v=4?s=100" width="100px;" alt="Mauro Chojrin"/><br /><sub><b>Mauro Chojrin</b></sub></a><br /><a href="https://github.com/mautic/mautic/commits?author=mchojrin" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://activelamp.com"><img src="https://avatars.githubusercontent.com/u/810903?v=4?s=100" width="100px;" alt="Tom Friedhof"/><br /><sub><b>Tom Friedhof</b></sub></a><br /><a href="https://github.com/mautic/mautic/issues?q=author%3Atomfriedhof" title="Bug reports">🐛</a> <a href="https://github.com/mautic/mautic/commits?author=tomfriedhof" title="Code">💻</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/MojisolaaaO"><img src="https://avatars.githubusercontent.com/u/173389301?v=4?s=100" width="100px;" alt="Mojisola Otusheso"/><br /><sub><b>Mojisola Otusheso</b></sub></a><br /><a href="https://github.com/mautic/mautic/issues?q=author%3AMojisolaaaO" title="Bug reports">🐛</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/nileshlohar"><img src="https://avatars.githubusercontent.com/u/18068907?v=4?s=100" width="100px;" alt="Nilesh Lohar"/><br /><sub><b>Nilesh Lohar</b></sub></a><br /><a href="https://github.com/mautic/mautic/commits?author=nileshlohar" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://simplyprint.io/"><img src="https://avatars.githubusercontent.com/u/11600207?v=4?s=100" width="100px;" alt="Albert Møller Nielsen"/><br /><sub><b>Albert Møller Nielsen</b></sub></a><br /><a href="https://github.com/mautic/mautic/issues?q=author%3AAlbertMN" title="Bug reports">🐛</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/TheMarvelFan"><img src="https://avatars.githubusercontent.com/u/93257324?v=4?s=100" width="100px;" alt="Kushagra Nigam"/><br /><sub><b>Kushagra Nigam</b></sub></a><br /><a href="https://github.com/mautic/mautic/commits?author=TheMarvelFan" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://laurielim.github.io"><img src="https://avatars.githubusercontent.com/u/62180225?v=4?s=100" width="100px;" alt="Laurie Lim Sam"/><br /><sub><b>Laurie Lim Sam</b></sub></a><br /><a href="#userTesting-laurielim" title="User Testing">📓</a> <a href="https://github.com/mautic/mautic/pulls?q=is%3Apr+reviewed-by%3Alaurielim" title="Reviewed Pull Requests">👀</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/caiqueportela"><img src="https://avatars.githubusercontent.com/u/44068957?v=4?s=100" width="100px;" alt="Caique Portela"/><br /><sub><b>Caique Portela</b></sub></a><br /><a href="https://github.com/mautic/mautic/commits?author=caiqueportela" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/levente999"><img src="https://avatars.githubusercontent.com/u/168987998?v=4?s=100" width="100px;" alt="levente999"/><br /><sub><b>levente999</b></sub></a><br /><a href="https://github.com/mautic/mautic/commits?author=levente999" title="Code">💻</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/rishithreddy89"><img src="https://avatars.githubusercontent.com/u/178993450?v=4?s=100" width="100px;" alt="rishithreddy89"/><br /><sub><b>rishithreddy89</b></sub></a><br /><a href="https://github.com/mautic/mautic/commits?author=rishithreddy89" title="Code">💻</a> <a href="#userTesting-rishithreddy89" title="User Testing">📓</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://linktr.ee/Jaishree2310"><img src="https://avatars.githubusercontent.com/u/73012522?v=4?s=100" width="100px;" alt="Jaishree Singh"/><br /><sub><b>Jaishree Singh</b></sub></a><br /><a href="https://github.com/mautic/mautic/commits?author=Jaishree2310" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/kingsedem"><img src="https://avatars.githubusercontent.com/u/47061881?v=4?s=100" width="100px;" alt="Kingsley_E_"/><br /><sub><b>Kingsley_E_</b></sub></a><br /><a href="#userTesting-kingsedem" title="User Testing">📓</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/Hugo-Prossaird"><img src="https://avatars.githubusercontent.com/u/176997845?v=4?s=100" width="100px;" alt="Hugo-Prossaird"/><br /><sub><b>Hugo-Prossaird</b></sub></a><br /><a href="https://github.com/mautic/mautic/commits?author=Hugo-Prossaird" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/farzammadani"><img src="https://avatars.githubusercontent.com/u/69846004?v=4?s=100" width="100px;" alt="Farzam Madani"/><br /><sub><b>Farzam Madani</b></sub></a><br /><a href="https://github.com/mautic/mautic/commits?author=farzammadani" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/SaraCRM"><img src="https://avatars.githubusercontent.com/u/121267071?v=4?s=100" width="100px;" alt="Sara Matos"/><br /><sub><b>Sara Matos</b></sub></a><br /><a href="https://github.com/mautic/mautic/commits?author=SaraCRM" title="Code">💻</a> <a href="https://github.com/mautic/mautic/commits?author=SaraCRM" title="Tests">⚠️</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/VishnuGurrapu"><img src="https://avatars.githubusercontent.com/u/169230642?v=4?s=100" width="100px;" alt="Vishnu Gurrapu"/><br /><sub><b>Vishnu Gurrapu</b></sub></a><br /><a href="https://github.com/mautic/mautic/commits?author=VishnuGurrapu" title="Code">💻</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/1792826181"><img src="https://avatars.githubusercontent.com/u/105675530?v=4?s=100" width="100px;" alt="Jun"/><br /><sub><b>Jun</b></sub></a><br /><a href="https://github.com/mautic/mautic/commits?author=1792826181" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/goma101"><img src="https://avatars.githubusercontent.com/u/104629384?v=4?s=100" width="100px;" alt="Guilherme Gomes"/><br /><sub><b>Guilherme Gomes</b></sub></a><br /><a href="https://github.com/mautic/mautic/commits?author=goma101" title="Code">💻</a> <a href="https://github.com/mautic/mautic/commits?author=goma101" title="Tests">⚠️</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/pedroasgomes"><img src="https://avatars.githubusercontent.com/u/99080726?v=4?s=100" width="100px;" alt="Pedro Gomes"/><br /><sub><b>Pedro Gomes</b></sub></a><br /><a href="https://github.com/mautic/mautic/commits?author=pedroasgomes" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/ElPollero"><img src="https://avatars.githubusercontent.com/u/130322184?v=4?s=100" width="100px;" alt="ElPollero"/><br /><sub><b>ElPollero</b></sub></a><br /><a href="https://github.com/mautic/mautic/commits?author=ElPollero" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://pelbox.com"><img src="https://avatars.githubusercontent.com/u/6670191?v=4?s=100" width="100px;" alt="Gagandeep Singh"/><br /><sub><b>Gagandeep Singh</b></sub></a><br /><a href="https://github.com/mautic/mautic/commits?author=pelbox" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/PedroLoureiro1"><img src="https://avatars.githubusercontent.com/u/116733776?v=4?s=100" width="100px;" alt="PedroLoureiro1"/><br /><sub><b>PedroLoureiro1</b></sub></a><br /><a href="https://github.com/mautic/mautic/commits?author=PedroLoureiro1" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/OlgaMarchuk"><img src="https://avatars.githubusercontent.com/u/219189660?v=4?s=100" width="100px;" alt="OlgaMarchuk"/><br /><sub><b>OlgaMarchuk</b></sub></a><br /><a href="#userTesting-OlgaMarchuk" title="User Testing">📓</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/stone-creator"><img src="https://avatars.githubusercontent.com/u/1327019?v=4?s=100" width="100px;" alt="Stone-creator"/><br /><sub><b>Stone-creator</b></sub></a><br /><a href="#userTesting-stone-creator" title="User Testing">📓</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/lolaslade"><img src="https://avatars.githubusercontent.com/u/2320484?v=4?s=100" width="100px;" alt="lolcode"/><br /><sub><b>lolcode</b></sub></a><br /><a href="https://github.com/mautic/mautic/commits?author=lolaslade" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://www.rodrigoaguilera.net"><img src="https://avatars.githubusercontent.com/u/655187?v=4?s=100" width="100px;" alt="Rodrigo"/><br /><sub><b>Rodrigo</b></sub></a><br /><a href="https://github.com/mautic/mautic/commits?author=rodrigoaguilera" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/DarshBhavnani"><img src="https://avatars.githubusercontent.com/u/131427031?v=4?s=100" width="100px;" alt="Darsh Bhavnani"/><br /><sub><b>Darsh Bhavnani</b></sub></a><br /><a href="https://github.com/mautic/mautic/commits?author=DarshBhavnani" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://www.clear-code.com/"><img src="https://avatars.githubusercontent.com/u/27350?v=4?s=100" width="100px;" alt="Sutou Kouhei"/><br /><sub><b>Sutou Kouhei</b></sub></a><br /><a href="https://github.com/mautic/mautic/commits?author=kou" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/naoya-kawakatsu"><img src="https://avatars.githubusercontent.com/u/49386563?v=4?s=100" width="100px;" alt="naoya-kawakatsu"/><br /><sub><b>naoya-kawakatsu</b></sub></a><br /><a href="https://github.com/mautic/mautic/commits?author=naoya-kawakatsu" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/BeniShoga1"><img src="https://avatars.githubusercontent.com/u/197698659?v=4?s=100" width="100px;" alt="Benisyoga"/><br /><sub><b>Benisyoga</b></sub></a><br /><a href="https://github.com/mautic/mautic/commits?author=BeniShoga1" title="Code">💻</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="https://niziol.me"><img src="https://avatars.githubusercontent.com/u/947620?v=4?s=100" width="100px;" alt="Krzysztof Nizioł"/><br /><sub><b>Krzysztof Nizioł</b></sub></a><br /><a href="https://github.com/mautic/mautic/commits?author=kniziol" title="Code">💻</a></td>
    </tr>
  </tbody>
</table>

<!-- markdownlint-restore -->
<!-- prettier-ignore-end -->

<!-- ALL-CONTRIBUTORS-LIST:END -->

This project follows the [all-contributors][all-contributors] specification. Contributions of any kind welcome!

[mautic-blog]: <https://www.mautic.org/blog>
[get-involved]: <https://www.mautic.org/community/get-involved>
[twitter]: <https://twitter.com/MauticCommunity>
[facebook]: <https://www.facebook.com/MauticCommunity/>
[slack]: <https://www.mautic.org/community/get-involved/communication-channels>
[contributing]: <https://contribute.mautic.org/contributing-to-mautic>
[contributing-md]: <https://github.com/mautic/mautic/blob/6.x/.github/CONTRIBUTING.md>
[contribute-developer]: <https://contribute.mautic.org/contributing-to-mautic/developer>
[t1-issues]: <https://github.com/mautic/mautic/issues?q=is%3Aissue+is%3Aopen+label%3AT1>
[download-mautic]: <https://www.mautic.org/download>
[tagged-release]: <https://github.com/mautic/mautic/releases>
[composer]: <http://getcomposer.org/>
[download-zip]: <https://github.com/mautic/mautic/archive/refs/heads/5.2.zip>
[ddev-mautic]: <https://kb.mautic.org/article/how-to-set-up-a-mautic-instance-for-testing-locally-with-ddev.html>
[troubleshooting]: <https://docs.mautic.org/en/troubleshooting>
[community]: <https://www.mautic.org/community>
[mautic-docs]: <https://docs.mautic.org>
[dev-docs]: <https://devdocs.mautic.org>
[all-contributors]: <https://github.com/all-contributors/all-contributors>
[best-pulls]: <https://github.com/mautic/mautic/pulls?q=is%3Aopen+is%3Apr+-label%3Ablocked+-label%3Awip+-is%3Adraft+-label%3Aready-to-commit+-label%3Apending-feedback+label%3Aready-to-test+status%3Asuccess>
[mautic-trials]: <https://mautic.org/start-using-mautic/try-mautic/>
[mautic-releases]: <https://www.mautic.org/mautic-releases>
[install-mautic-composer]: <https://docs.mautic.org/en/5.2/getting_started/how_to_install_mautic.html#installing-with-composer>
[requirements]: <https://mautic.org/mautic-requirements/>
[supported-versions]: <https://mautic.org/releases/>
[low-no-code]: <https://mau.tc/no-code>
